<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('excel_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('uploaded_file_id')->constrained()->onDelete('cascade');
            
            // Excel columns from قائمة العملاء.xlsx
            $table->string('name', 255)->nullable()->index(); // الاسم
            $table->string('mobile_number', 50)->nullable()->index(); // رقم الموبايل
            $table->string('membership_card_number', 100)->nullable()->index(); // رقم بطاقة العضوية
            $table->text('address')->nullable(); // العنوان
            $table->string('house_number', 50)->nullable(); // رقم منزل
            $table->string('neighborhood', 255)->nullable(); // الحي
            $table->text('work_address')->nullable(); // عنوان العمل
            $table->text('home_address')->nullable(); // عنوان المنزل
            $table->string('governorate', 255)->nullable()->index(); // المحافظة
            $table->text('complaints')->nullable(); // شكاوى
            $table->text('notes')->nullable(); // ملاحظات
            $table->date('expiry_date')->nullable()->index(); // تاريخ الانتهاء
            $table->string('membership_type', 100)->nullable()->index(); // نوع العضوية
            $table->string('valid_status', 50)->nullable()->index(); // ساري حق
            
            $table->timestamps();
            
            // Additional indexes for performance
            $table->index('uploaded_file_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('excel_records');
    }
};
